package w83a.objects;

import java.io.IOException;
import java.io.StringReader;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

import org.apache.xpath.XPathAPI;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
public class W83aThirdPartySessionObject extends W83aBaseObject {

	/**
	 * 
	 */
	private static final long serialVersionUID = 2055034194869572074L;

	public static final String FILTRO_POLITICA="//parent::certificate/certificado/politica/text()";
	public static final String FILTRO_CIF_ENTIDAD="//parent::certificate/certificado/entidad/cif/text()";
	public static final String FILTRO_RAZON_ENTIDAD="//parent::certificate/certificado/entidad/razonSocial/text()";
	public static final String FILTRO_DNI_CIUDADANO="//parent::certificate/certificado/suscriptor/dni/text()";
	public static final String FILTRO_NOMBRE_CIUDADANO="//parent::certificate/certificado/suscriptor/nombreCompleto/text()";
	public static final String FILTRO_NOMBRE_TITULAR="//parent::certificate/certificado/suscriptor/nombre/text()";
	public static final String FILTRO_APELLIDOS_TITULAR="//parent::certificate/certificado/suscriptor/apellidos/text()";
	public static final String FILTRO_NUMERO_BARCOS="//parent::IdentificacionResponse/datosJuegoBarcos/numeroRefJuegoBarcos/text()";
	public static final String FILTRO_DNI_BARCOS="//parent::IdentificacionResponse/datosPersona/DNI/text()";
	public static final String FILTRO_NOMBRE_BARCOS="//parent::IdentificacionResponse/datosPersona/nombre/text()";
	public static final String FILTRO_APELLIDO1_BARCOS="//parent::IdentificacionResponse/datosPersona/primerApellido/text()";
	public static final String FILTRO_APELLIDO2_BARCOS="//parent::IdentificacionResponse/datosPersona/segundoApellido/text()";
	public static final String FILTRO_REF_BARCOS="//parent::IdentificacionResponse/datosJuegoBarcos/numeroRefJuegoBarcos/text()";
	
	private String politica;
	private boolean entidad;
	private String idDocumento;
	private String nombre;
	private String nombreTitular;
	private String apellidosTitular;
	private boolean juegoDeBarcos;
	private String ref;//numeroRefJuegoBarcos
	
	public W83aThirdPartySessionObject(){
		
		this.politica=null;
		this.entidad=false;
		this.idDocumento=null;
		this.nombre =null;
		this.nombreTitular=null;
		this.apellidosTitular=null;
		this.juegoDeBarcos=false;
		this.ref=null;
	}
	
	public String getId() {
		// TODO Auto-generated method stub
		return null;
	}

	public String getValue() {
		// TODO Auto-generated method stub
		return null;
	}
	
	public void parse(String xml) throws SAXException, IOException, ParserConfigurationException, FactoryConfigurationError, DOMException, TransformerException{
		
		if(xml!=null){
		
		    DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
		    InputSource is = new InputSource();
		    is.setCharacterStream(new StringReader(xml));
		    Document document = db.parse(is);
		    
		    this.juegoDeBarcos= XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_NUMERO_BARCOS).getLength()>0;
		    
		    if(this.juegoDeBarcos){
		    	this.entidad=false;
		    	this.idDocumento=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_DNI_BARCOS).item(0).getNodeValue();
		    	this.nombreTitular=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_NOMBRE_BARCOS).item(0).getNodeValue();
		    	this.apellidosTitular=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_APELLIDO1_BARCOS).item(0).getNodeValue() + " " + XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_APELLIDO2_BARCOS).item(0).getNodeValue();
		    	this.nombre=this.nombreTitular + " " + this.apellidosTitular;
		    	this.ref=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_REF_BARCOS).item(0).getNodeValue();
		    }else{
			    this.politica=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_POLITICA).item(0).getNodeValue();
			    this.entidad= XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_CIF_ENTIDAD).getLength()>0;
			    if(this.entidad){
			    	this.idDocumento=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_CIF_ENTIDAD).item(0).getNodeValue();
			    	this.nombre=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_RAZON_ENTIDAD).item(0).getNodeValue();
			    }else{
			    	this.idDocumento=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_DNI_CIUDADANO).item(0).getNodeValue();
			    	this.nombre=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_NOMBRE_CIUDADANO).item(0).getNodeValue();
			    	this.nombreTitular=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_NOMBRE_TITULAR).item(0).getNodeValue();
			    	this.apellidosTitular=XPathAPI.selectNodeList(document, W83aThirdPartySessionObject.FILTRO_APELLIDOS_TITULAR).item(0).getNodeValue();
			    }
		    }
		}else{
			this.setPolitica(null);
			this.setJuegoDeBarcos(false);
		}
	    	
	    
		
	    
	
	}

	public String getPolitica() {
		return this.politica;
	}

	public void setPolitica(String politica) {
		this.politica = politica;
	}

	public boolean isEntidad() {
		return this.entidad;
	}

	public void setEntidad(boolean entidad) {
		this.entidad = entidad;
	}

	public String getIdDocumento() {
		return this.idDocumento;
	}

	public void setIdDocumento(String idDocumento) {
		this.idDocumento = idDocumento;
	}

	public String getNombre() {
		return this.nombre;
	}

	public void setNombre(String nombre) {
		this.nombre = nombre;
	}

	public String getApellidosTitular() {
		return this.apellidosTitular;
	}

	public void setApellidosTitular(String apellidosTitular) {
		this.apellidosTitular = apellidosTitular;
	}

	public String getNombreTitular() {
		return this.nombreTitular;
	}

	public void setNombreTitular(String nombreTitular) {
		this.nombreTitular = nombreTitular;
	}

	public boolean isJuegoDeBarcos() {
		return this.juegoDeBarcos;
	}

	public void setJuegoDeBarcos(boolean juegoDeBarcos) {
		this.juegoDeBarcos = juegoDeBarcos;
	}

	public String getRef() {
		return this.ref;
	}

	public void setRef(String ref) {
		this.ref = ref;
	}
	
	
	
	
	

}
